% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TvCcomp.m
function [beta, gamma, Nm, Sa, Aa, Af, r2_full, r2_reduced, ...
      F, df1, df2,  p] = TvCcomp(TvCs, Nstates)  
        % TvCs contains the measured TvCs

NperformanceLevels = (size(TvCs, 1) - 1)/Nstates;
NnoiseLevels = size(TvCs, 2) - 1;

% full model fit
data = [Nstates zeros(1, NnoiseLevels); TvCs];   
        % include info on # of states and # of performance
        % levels
guess = [4 2 0.1 0.01 0.50*ones(1, Nstates - 1) ...
     0.50*ones(1, Nstates - 1) ]; % beta gamma Nm Sa Aa's Af's
options = optimset('fminsearch');
[guess, fullmodel_L] = fminsearch('TvCcomp_costfunc', guess, ...
     options, data);

beta = guess(1);
gamma = guess(2);
Nm = guess(3);
Sa = guess(4);
Aa = [1 guess(5 : (5 + Nstates - 2))];
Af = [1 guess((5+Nstates-1) : (5 + 2* Nstates -3))];

%reduced model: same parameters for all TvCs
data=TvCs;
guess = [4 2 0.1 0.01];   % Gmax, Fmax, beta, delta
options = optimset('fminsearch');
[guess, reducedmodel_L] = fminsearch('TvCcostfunc', guess, ...
      options, data);
meanLogS = mean(mean(log(TvCs(2:(NperformanceLevels*Nstates), ...
      2:NnoiseLevels))));
SS = sum(sum((log(TvCs(2:(NperformanceLevels*Nstates), ...
      2:NnoiseLevels)) - meanLogS).^2));
r2_full = 1 - fullmodel_L/SS;
r2_reduced = 1 - reducedmodel_L/SS;
df1 = 2*(Nstates-1);
df2 = Nstates*NperformanceLevels*NnoiseLevels - 4 - ...
      2*(Nstates-1);
F = (r2_full - r2_reduced)/df1 / ((1 - r2_full)/df2);
p = 1 - fcdf(F, df1, df2);
